/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import com.mrcrayfish.framework.util.GsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class OpenModel
implements IModelGeometry<OpenModel> {
    private final BlockModel model;

    public OpenModel(BlockModel model) {
        this.model = model;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return this.model.m_111449_(bakery, this.model, spriteGetter, modelTransform, modelLocation, true);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.m_5500_(modelGetter, missingTextureErrors);
    }

    public static class Deserializer
    extends BlockModel.Deserializer {
        private static final BlockElement.Deserializer BLOCK_PART_DESERIALIZER = new BlockElement.Deserializer();
        private static final Deserializer INSTANCE = new Deserializer();

        protected List<BlockElement> m_111506_(JsonDeserializationContext context, JsonObject object) {
            try {
                ArrayList<BlockElement> list = new ArrayList<BlockElement>();
                for (JsonElement element : GsonHelper.m_13832_((JsonObject)object, (String)"components", (JsonArray)new JsonArray())) {
                    list.add(this.readBlockElement(element, context));
                }
                return list;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private BlockElement readBlockElement(JsonElement element, JsonDeserializationContext context) throws Exception {
            JsonObject object = element.getAsJsonObject();
            Vector3f from = GsonUtils.getVector3f(object, "from");
            Vector3f to = GsonUtils.getVector3f(object, "to");
            JsonObject rotation = GsonHelper.m_13841_((JsonObject)object, (String)"rotation", (JsonObject)new JsonObject());
            float angle = GsonHelper.m_13820_((JsonObject)rotation, (String)"angle", (float)0.0f);
            JsonArray zero = new JsonArray();
            zero.add((Number)Float.valueOf(0.0f));
            zero.add((Number)Float.valueOf(0.0f));
            zero.add((Number)Float.valueOf(0.0f));
            object.add("from", (JsonElement)zero);
            object.add("to", (JsonElement)zero);
            rotation.addProperty("angle", (Number)Float.valueOf(0.0f));
            BlockElement e = BLOCK_PART_DESERIALIZER.deserialize(element, BlockElement.class, context);
            BlockElementRotation r = e.f_111311_ != null ? new BlockElementRotation(e.f_111311_.f_111378_, e.f_111311_.f_111379_, angle, e.f_111311_.f_111381_) : null;
            return new BlockElement(from, to, e.f_111310_, r, e.f_111312_);
        }
    }

    @Mod.EventBusSubscriber(modid="framework", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Loader
    implements IModelLoader<OpenModel> {
        public void m_6213_(ResourceManager manager) {
        }

        public OpenModel read(JsonDeserializationContext context, JsonObject object) {
            return new OpenModel(Deserializer.INSTANCE.deserialize((JsonElement)object, (Type)((Object)BlockModel.class), context));
        }

        @SubscribeEvent
        public static void onModelRegister(ModelRegistryEvent event) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("framework", "open_model"), (IModelLoader)new Loader());
        }
    }
}

